% Section 3.8 Tutorial Example 2
% 29/02/2020, Jianglin Lan
close all
clear
clc

% Set up Yalmip & Mosek, this may differ on different computer
% Find installation details in links: 
% https://yalmip.github.io/tutorial/installation/
% https://docs.mosek.com/9.1/toolbox/install-interface.html
addpath(genpath('C:\YALMIP-master'))
addpath('C:\Program Files\Mosek\8\toolbox\r2014a')

% System matrices
A = [24   12; -4.4379    2.2189]; 
B = [1; 0]; 
F = B; 
D = [1;1];
C = [1 0];

[n,m] = size(B);
[~,q] = size(F);
[~,l] = size(D);
[p,~] = size(C);

% uncertainty
Mc = eye(n);
Nc = 0.1*A;
Delta_A = Mc*Nc;

% Controller & observer gains
run('Step1_Controller_design.m');
run('Step2_Observer_design.m');

% Define global variables to store data
global tmp count ts ex1 ex2 ef ff
tmp = 0; count = 0; ts = []; ex1 = []; ex2 = []; ef = []; ff = [];

% Simulation time span
t0 = 0;
tf = 30;
tspan = [t0 tf];

% Initial conditon
x0 = [0.1 0];
hat_Xf0 = zeros(1,n+2*q);
xx0 = [x0 hat_Xf0];

% Solve differential equation
[tt,sys] = ode45(@(t,xx) Closed_sys_performance(t,xx,A,Delta_A,B,F,D,C,K,L), tspan, xx0);
x1 = sys(:,1);
x2 = sys(:,2);
hat_f = sys(:,5);

% Draw figures
run('Draw_figures.m');